package gov.va.vamf.scheduling.varutility.resource;

import com.agilex.healthcare.mobilehealthplatform.security.AppUser;
import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.DomainBaseObject;
import gov.va.vamf.scheduling.varutility.domain.RequestEligibilityCriteria;
import gov.va.vamf.scheduling.varutility.linkbuilder.LinkBuilder;
import gov.va.vamf.scheduling.varutility.service.ClinicalServicesService;
import gov.va.vamf.scheduling.varutility.service.RequestEligibilityCriteriaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;

import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import java.security.Principal;
import java.util.Date;
import java.util.List;

@Path("/request-eligibility-criteria/site/{site-code}")
@Component
@Scope("request")
public class RequestEligibilityCriteriaResource {

    @Autowired
    private ClinicalServicesService clinicalServicesService;

    @Autowired
    private RequestEligibilityCriteriaService requestEligibilityCriteriaService;

    @GET
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    public RequestEligibilityCriteria fetchRequestEligibilityCriteria(
            @Context UriInfo uriInfo,
            @PathParam("site-code") String siteCode) {

        List<ClinicalServices> requestServices = clinicalServicesService.fetchForRequest();
        List<ClinicalServices> customRequestServices = clinicalServicesService.fetchForCustomRequest();
        RequestEligibilityCriteria requestEligibilityCriteria = requestEligibilityCriteriaService.fetchRequestEligibiltyCriteria(siteCode,
                requestServices, customRequestServices, uriInfo);
        return requestEligibilityCriteria;
    }

    @POST
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
    public RequestEligibilityCriteria savedRequestEligibilityCriteria( RequestEligibilityCriteria requestEligibilityCriteria,
                                                                       @Context UriInfo uriInfo, @Context SecurityContext securityContext,
                                                                       @PathParam("site-code") String siteCode) {

        List<ClinicalServices> requestServices = clinicalServicesService.fetchForRequest();
        List<ClinicalServices> customRequestServices = clinicalServicesService.fetchForCustomRequest();
        requestEligibilityCriteria.validate(siteCode, requestServices, customRequestServices);
        requestEligibilityCriteria.setCreatedDate(new Date());
        requestEligibilityCriteria.setCreatedBy(getUserName(securityContext));
        requestEligibilityCriteria.cleanupDataForSave();
        RequestEligibilityCriteria savedRequestEligibilityCriteria = requestEligibilityCriteriaService.saveRequestEligibilityCriteria(requestEligibilityCriteria);
        LinkBuilder.fillLink(savedRequestEligibilityCriteria, uriInfo.getRequestUri());
        return savedRequestEligibilityCriteria;
    }

    @PUT
    @Path( "/id/{id}" )
    @Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
    @Consumes({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
    public RequestEligibilityCriteria updateRequestEligibilityCriteria(RequestEligibilityCriteria requestEligibilityCriteria,
                                                                       @Context UriInfo uriInfo, @Context SecurityContext securityContext,
                                                                       @PathParam("site-code") String siteCode,
                                                                       @PathParam("id") String id) {

        List<ClinicalServices> requestServices = clinicalServicesService.fetchForRequest();
        List<ClinicalServices> customRequestServices = clinicalServicesService.fetchForCustomRequest();
        requestEligibilityCriteria.validate(siteCode, requestServices, customRequestServices);
        requestEligibilityCriteria.setLastModifiedDate(new Date());
        requestEligibilityCriteria.setModifiedBy(getUserName(securityContext));
        requestEligibilityCriteria.cleanupDataForSave();
        RequestEligibilityCriteria updatedRequestEligibilityCriteria = requestEligibilityCriteriaService.updateRequestEligibilityCriteria(requestEligibilityCriteria);
        LinkBuilder.fillLink(updatedRequestEligibilityCriteria, uriInfo.getRequestUri());
        return updatedRequestEligibilityCriteria;
    }

    private String getUserName(SecurityContext securityContext) {
        Principal principal = securityContext.getUserPrincipal();
        AppUser appUser = (AppUser)((OAuth2Authentication) principal).getUserAuthentication().getPrincipal();
        return appUser.getMhpUser().getDisplayName();
    }
}
